% Multi-Modality Feature Transform for image segmentation
%
% (c) Moustafa Meshry, moustafa.meshry@alexu.edu.eg
%     Department of Compter and Systems Engineering, Alexandria University, Egypt.

clear;
iptsetpref('ImshowBorder','tight');

%% scribbled dataset

imgPath = fullfile('images', 'person_2007_006364.jpg');
imgAnnotationPath = fullfile('images', 'person_2007_006364-anno.png');
groundTruthPath = fullfile('images', 'person_2007_006364.png');

%% Input

img_rgb = imread(imgPath);

[fgSample, bgSample] = loadAnnotation(imgAnnotationPath);
annotated = visualizeAnnotatedImage(img_rgb, fgSample, bgSample);

%% Algorithm #1: 1-pass LDA

tic;
segmentedImage_lda = segmentImageLDA(imgPath, fgSample, bgSample);
ldaTime = toc;
ldaTitle = sprintf('1-pass LDA -- Time = %.2f seconds', ldaTime);
lda = visualizeSegmentation(img_rgb, segmentedImage_lda, ldaTitle);
jaccard_lda = evaluateSegmentation(groundTruthPath, segmentedImage_lda, false);
fprintf('Jaccard index for lda = %f\n', jaccard_lda);

%% Algorithm #2: Iterative LDA

tic;
segmentedImage_ldaIter = segmentImageLDAIter(imgPath, fgSample, bgSample);
ldaIterTime = toc;
ldaIterTitle = sprintf('Iterative LDA -- Time = %.2f seconds', ldaIterTime);
ldaIter = visualizeSegmentation(img_rgb, segmentedImage_ldaIter, ldaIterTitle);
jaccard_ldaIter = evaluateSegmentation(groundTruthPath, segmentedImage_ldaIter, false);
fprintf('Jaccard index for iterative lda = %f\n', jaccard_ldaIter);

%% Algorithm #3: 1-pass LFDA

tic;
segmentedImage_lfda = segmentImageLFDA(imgPath, fgSample, bgSample);
lfdaTime = toc;
lfdaTitle = sprintf('1-pass MMFT -- Time = %.2f seconds', lfdaTime);
lfda = visualizeSegmentation(img_rgb, segmentedImage_lfda, lfdaTitle);
jaccard_lfda = evaluateSegmentation(groundTruthPath, segmentedImage_lfda, false);
fprintf('Jaccard index for lfda = %f\n', jaccard_lfda);

%% Algorithm #4: Iterative LFDA

tic;
segmentedImage_lfdaIter = segmentImageLFDAIter(imgPath, fgSample, bgSample);
lfdaIterTime = toc;
lfdaIterTitle = sprintf('Iterative MMFT -- Time = %.2f seconds', lfdaIterTime);
lfdaIter = visualizeSegmentation(img_rgb, segmentedImage_lfdaIter, lfdaIterTitle);
jaccard_lfdaIter = evaluateSegmentation(groundTruthPath, segmentedImage_lfdaIter, false);
fprintf('Jaccard index for iterative lfda = %f\n', jaccard_lfdaIter);

%% Visualize All

figure('Name', 'Summary', 'units','normalized','outerposition',[0 0 1 1]);
subplot(2,2,1);
imshow(lda);
title(ldaTitle);

subplot(2,2,2);
imshow(ldaIter);
title(ldaIterTitle);

subplot(2,2,3);
imshow(lfda);
title(lfdaTitle);

subplot(2,2,4);
imshow(lfdaIter);
title(lfdaIterTitle);
